*Title: How to resolve an email conflict?
*Slug: resolving-email-conflict

================================================================

Occasionally, when trying to import an email message, activeCollab can come across an <{term}>Email Conflict<{/term}>. It usually happens when an <{term}>Incoming Mail Filter<{/term}> cannot be applied to the email message found in the mailbox, or if the Mail to Project email has not been delivered properly.

<{note title="How will I know that an Email Conflict has occurred?"}>You will be notified about the email conflict:
- by receiving an email about it. Please note that only administrator users will receive such emails.
- by a red index number on the <{term}>Administration<{/term}> icon.
- in the <{term}>System Notifications<{/term}> area on the <{term}>Dashboard<{/term}>.<{/note}>

To resolve email conflicts and examine what has happened, go to the <{option}>Administration > Email<{/option}> and open the <{option}>Incoming Mail Conflicts<{/option}> tab. You will see a list of messages describing what has caused a conflict. To see additional details, click the "<{option}>Magnifying glass<{/option}> icon. This is also where you can resolve email conflicts.

<{image name="email_conflicts.png"}>

<{sub}>Common Causes for Email Conflicts<{/sub}>

- **Project Does Not Exist**

Remember to notify users who are using Mail to Project to edit incoming mail filters after removing a project from activeCollab.

In case you receive an email with the address to a specific project or you have set the filter to create a new task, discussion or file in a project that you have moved to trash, a conflict will occur. The system will not be aware of the location where the project item should have been placed. You can resolve the conflict either by choosing another project for the new item or by removing the email message.

- **User Does Not Have the Permission to Create an Object**

When creating incoming mail filters, there is an option to restrict creating new tasks, discussions or files by users without the corresponding permissions enabled. If you have enabled the option in the filter, only activeCollab users with "Access and Create" and "Access, Create and Manage" <{page name="project-roles" book="people"}>Project Permissions<{/page}> enabled will be allowed to create a new object by sending an email.

All emails sent from external users or users without the appropriate project permission will create a conflict. You can choose whether you wish to resolve this conflict by removing the project permission restriction or by removing the conflicting email from the system.

- **Email Does Not Match Any of the Filters**

If an email message does not match any of the predefined filter criteria in your system, the email will create a conflict.

To resolve this, simply create or edit the filters to include the content of this email or remove the email from your activeCollab.